function [pprisknewprofilet]=postprocessnewprofile(xnew,nuoflevels,psicsave,phisave,riskthetasave,iterations,maxnumberofclusters)

% THIS FUNCTION POST PROCESSES THE SAMPLED PHI'S PSI'S AND THETA'S IN
% ORDER TO ESTIMATE THE RISK FOR A NEW PROFILE, IN THE FOLLOWING WAY:
% a) Run the profile through all the iterations
% b) For every iteration choose the most likely cluster for this profile,
%    calculating the probability of the profile for each cluster
% c) choose the corresponding theta and save it.

pprisknewprofilet=zeros(iterations,1);
xnew11=xnew; xnew11(xnew11==100)=0;

xind=xnew11(1)+1; % indicator for selecting the right elements of phisave{itemp,ictemp,:}. 
for itemp=2:size(nuoflevels,2)
    xind=[xind sum(nuoflevels(1:itemp-1))+xnew11(itemp)+1]; 
end

for itemp=1:iterations
    probabofx=zeros(1,maxnumberofclusters);
    for ictemp=1:maxnumberofclusters
        phitemp=[phisave{itemp,ictemp,:}]; % creates a vector with the elements of phisave{itemp,ictemp,:}
        phitemp2=phitemp(1,xind);
        probabofx(1,ictemp)=prod(phitemp2(xnew~=100)); % select according to xnew and 100
    end
    probab=psicsave(itemp,:).*probabofx;
    probab=probab*(sum(probab)^(-1));
    
    correct=1-sum(probab);
    probab(max(probab)==probab)=...
        probab(max(probab)==probab)+correct;
    if (abs(1-sum(probab))>1E-16)
        correct=1-sum(probab);
        probab(max(probab)==probab)=...
            probab(max(probab)==probab)+correct;
    end
    
    tempriskvector=riskthetasave(itemp,:);
    pprisknewprofilet(itemp,1)=tempriskvector(logical(mnrnd(1,probab,1)));
    
    %pprisknewprofilet(itemp,1)=sum(riskthetasave(itemp,:).*probab); % OLD WAY
end        

figure(60);
hist(pprisknewprofilet,1000);
mean(pprisknewprofilet)
median(pprisknewprofilet)